/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.AssetUploadInfoRequestEvent;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.cabinet.GetAssetUploadUrl;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.overlays.CenterOverlay;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class UploadAssetOverlay
extends CenterOverlay {
    private static final HttpClient client = HttpClient.newBuilder().build();
    private Button uploadSkin;
    private Button uploadCape;
    private CheckBox useSlim;
    private AssetUploadInfoRequestEvent.SlimSupportConf slimSupportConf;

    public UploadAssetOverlay(JavaFXApplication application) {
        super("overlay/uploadasset/uploadasset.fxml", application);
    }

    @Override
    public String getName() {
        return "uploadasset";
    }

    @Override
    protected void doInit() {
        this.uploadSkin = (Button)LookupHelper.lookup((Node)this.layout, "#uploadskin");
        this.uploadCape = (Button)LookupHelper.lookup((Node)this.layout, "#uploadcape");
        this.useSlim = (CheckBox)LookupHelper.lookup((Node)this.layout, "#useslim");
        this.uploadSkin.setOnAction(a -> this.uploadAsset("SKIN", switch (this.slimSupportConf) {
            default -> throw new IncompatibleClassChangeError();
            case AssetUploadInfoRequestEvent.SlimSupportConf.USER -> new AssetOptions(this.useSlim.isSelected());
            case AssetUploadInfoRequestEvent.SlimSupportConf.UNSUPPORTED, AssetUploadInfoRequestEvent.SlimSupportConf.SERVER -> null;
        }));
        this.uploadCape.setOnAction(a -> this.uploadAsset("CAPE", null));
        LookupHelper.lookupIfPossible((Node)this.layout, "#close").ifPresent(b -> b.setOnAction(e -> this.hide(0.0, null)));
    }

    public void onAssetUploadInfo(AssetUploadInfoRequestEvent event) {
        boolean uploadSkinAvailable = event.available.contains("SKIN");
        boolean uploadCapeAvailable = event.available.contains("CAPE");
        this.uploadSkin.setVisible(uploadSkinAvailable);
        this.uploadCape.setVisible(uploadCapeAvailable);
        this.slimSupportConf = event.slimSupportConf;
        if (uploadSkinAvailable) {
            switch (event.slimSupportConf) {
                case USER: {
                    this.useSlim.setVisible(true);
                    break;
                }
                case UNSUPPORTED: 
                case SERVER: {
                    this.useSlim.setVisible(false);
                }
            }
        }
    }

    public void uploadAsset(String name, AssetOptions options) {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG Image", new String[]{"*.png"}));
        File file = chooser.showOpenDialog((Window)this.currentStage.getStage());
        if (file == null) {
            return;
        }
        this.application.gui.processingOverlay.processRequest(this.currentStage, this.application.getTranslation("runtime.overlay.processing.text.uploadasset"), new GetAssetUploadUrl(name), e -> {
            byte[] postFileData;
            byte[] preFileData;
            String accessToken = e.token == null ? Request.getAccessToken() : e.token.accessToken;
            String boundary = SecurityHelper.toHex((byte[])SecurityHelper.randomBytes((int)32));
            String jsonOptions = options != null ? Launcher.gsonManager.gson.toJson((Object)options) : "{}";
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(256);){
                output.write("--".getBytes(StandardCharsets.UTF_8));
                output.write(boundary.getBytes(StandardCharsets.UTF_8));
                output.write("\r\nContent-Disposition: form-data; name=\"options\"\r\nContent-Type: application/json\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                output.write(jsonOptions.getBytes(StandardCharsets.UTF_8));
                output.write("\r\n--".getBytes(StandardCharsets.UTF_8));
                output.write(boundary.getBytes(StandardCharsets.UTF_8));
                output.write("\r\nContent-Disposition: form-data; name=\"file\"; filename=\"file\"\r\nContent-Type: image/png\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                preFileData = output.toByteArray();
            }
            catch (IOException ex) {
                this.errorHandle(ex);
                return;
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(128);){
                output.write("\r\n--".getBytes(StandardCharsets.UTF_8));
                output.write(boundary.getBytes(StandardCharsets.UTF_8));
                output.write("--\r\n".getBytes(StandardCharsets.UTF_8));
                postFileData = output.toByteArray();
            }
            catch (IOException ex) {
                this.errorHandle(ex);
                return;
            }
            LogHelper.dev((String)"%s<DATA>%s", (Object[])new Object[]{new String(preFileData), new String(postFileData)});
            try {
                ((CompletableFuture)client.sendAsync(HttpRequest.newBuilder().uri(URI.create(e.url)).POST(HttpRequest.BodyPublishers.concat(HttpRequest.BodyPublishers.ofByteArray(preFileData), HttpRequest.BodyPublishers.ofFile(file.toPath()), HttpRequest.BodyPublishers.ofByteArray(postFileData))).header("Authorization", "Bearer " + accessToken).header("Content-Type", "multipart/form-data; boundary=\"" + boundary + "\"").header("Accept", "application/json").build(), HttpResponse.BodyHandlers.ofByteArray()).thenAccept(response -> {
                    LogHelper.dev((String)new String((byte[])response.body()));
                    if (response.statusCode() >= 200 && response.statusCode() < 300) {
                        try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream((byte[])response.body()));){
                            Texture texture = ((UserTexture)Launcher.gsonManager.gson.fromJson((Reader)reader, UserTexture.class)).toLauncherTexture();
                            URI skinUrl = new URI(texture.url);
                            if ("SKIN".equals(name)) {
                                this.application.skinManager.addOrReplaceSkin(this.application.authService.getUsername(), skinUrl);
                                for (AbstractVisualComponent scene : this.application.gui.getComponents()) {
                                    if (!scene.isInit() || !(scene instanceof SceneSupportUserBlock)) continue;
                                    SceneSupportUserBlock supportUserBlock = (SceneSupportUserBlock)((Object)scene);
                                    supportUserBlock.getUserBlock().resetAvatar();
                                }
                            }
                            this.contextHelper.runInFxThread(() -> this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.uploadasset.success.header"), this.application.getTranslation("runtime.overlay.uploadasset.success.description")));
                        }
                        catch (IOException | URISyntaxException ex) {
                            this.errorHandle(ex);
                        }
                    } else {
                        try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream((byte[])response.body()));){
                            UploadError error = (UploadError)Launcher.gsonManager.gson.fromJson((Reader)reader, UploadError.class);
                            this.errorHandle((Throwable)new RequestException(error.error));
                        }
                        catch (Exception ex) {
                            this.errorHandle(ex);
                        }
                    }
                })).exceptionally(th -> {
                    this.errorHandle((Throwable)th);
                    return null;
                });
            }
            catch (Throwable ex) {
                this.errorHandle(ex);
            }
        }, this::errorHandle, (EventHandler<ActionEvent>)((EventHandler)e -> {}));
    }

    @Override
    public void reset() {
    }

    public static final class AssetOptions {
        @LauncherNetworkAPI
        private final boolean modelSlim;

        public AssetOptions(boolean modelSlim) {
            this.modelSlim = modelSlim;
        }

        public boolean modelSlim() {
            return this.modelSlim;
        }
    }

    public record UserTexture(@LauncherNetworkAPI String url, @LauncherNetworkAPI String digest, @LauncherNetworkAPI Map<String, String> metadata) {
        Texture toLauncherTexture() {
            return new Texture(this.url, SecurityHelper.fromHex((String)this.digest), this.metadata);
        }
    }

    public record UploadError(@LauncherNetworkAPI String error) {
    }
}

